/*
 * Decompiled with CFR 0.152.
 */
package com.akuleshov7.ktoml.tree.nodes.pairs.values;

import com.akuleshov7.ktoml.TomlOutputConfig;
import com.akuleshov7.ktoml.exceptions.ParseException;
import com.akuleshov7.ktoml.parsers.StringUtilsKt;
import com.akuleshov7.ktoml.tree.nodes.pairs.values.TomlValue;
import com.akuleshov7.ktoml.utils.SpecialCharactersKt;
import com.akuleshov7.ktoml.writers.TomlEmitter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/akuleshov7/ktoml/tree/nodes/pairs/values/TomlBasicString;", "Lcom/akuleshov7/ktoml/tree/nodes/pairs/values/TomlValue;", "content", "", "multiline", "", "<init>", "(Ljava/lang/Object;Z)V", "", "lineNo", "", "(Ljava/lang/String;I)V", "getContent", "()Ljava/lang/Object;", "setContent", "(Ljava/lang/Object;)V", "getMultiline", "()Z", "setMultiline", "(Z)V", "write", "", "emitter", "Lcom/akuleshov7/ktoml/writers/TomlEmitter;", "config", "Lcom/akuleshov7/ktoml/TomlOutputConfig;", "Companion", "ktoml-core"})
public final class TomlBasicString
extends TomlValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Object content;
    private boolean multiline;

    public TomlBasicString(@NotNull Object content, boolean multiline) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        super(null);
        this.content = content;
        this.multiline = multiline;
    }

    public /* synthetic */ TomlBasicString(Object object, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(object, bl);
    }

    @Override
    @NotNull
    public Object getContent() {
        return this.content;
    }

    @Override
    public void setContent(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this.content = object;
    }

    public final boolean getMultiline() {
        return this.multiline;
    }

    public final void setMultiline(boolean bl) {
        this.multiline = bl;
    }

    public TomlBasicString(@NotNull String content, int lineNo) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this(TomlBasicString.Companion.verifyAndTrimQuotes(content, lineNo), false, 2, null);
    }

    @Override
    public void write(@NotNull TomlEmitter emitter, @NotNull TomlOutputConfig config) {
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Object object = this.getContent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String content = (String)object;
        emitter.emitValue(SpecialCharactersKt.escapeSpecialCharacters(content, this.multiline), false, this.multiline);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\t\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/akuleshov7/ktoml/tree/nodes/pairs/values/TomlBasicString$Companion;", "", "<init>", "()V", "verifyAndTrimQuotes", "", "lineNo", "", "checkOtherQuotesAreEscaped", "checkCountOfOtherUnescapedQuotes", "ktoml-core"})
    @SourceDebugExtension(value={"SMAP\nTomlBasicString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomlBasicString.kt\ncom/akuleshov7/ktoml/tree/nodes/pairs/values/TomlBasicString$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,97:1\n1188#2,3:98\n*S KotlinDebug\n*F\n+ 1 TomlBasicString.kt\ncom/akuleshov7/ktoml/tree/nodes/pairs/values/TomlBasicString$Companion\n*L\n71#1:98,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Object verifyAndTrimQuotes(String $this$verifyAndTrimQuotes, int lineNo) {
            String string;
            if (StringsKt.startsWith$default((String)$this$verifyAndTrimQuotes, (String)"\"\"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)$this$verifyAndTrimQuotes, (String)"\"\"\"", (boolean)false, (int)2, null)) {
                string = SpecialCharactersKt.convertSpecialCharacters(StringUtilsKt.convertLineEndingBackslash(this.checkCountOfOtherUnescapedQuotes(StringUtilsKt.trimMultilineQuotes($this$verifyAndTrimQuotes), lineNo)), lineNo);
            } else if (StringsKt.startsWith$default((String)$this$verifyAndTrimQuotes, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)$this$verifyAndTrimQuotes, (String)"\"", (boolean)false, (int)2, null)) {
                string = SpecialCharactersKt.convertSpecialCharacters(this.checkOtherQuotesAreEscaped(StringUtilsKt.trimQuotes($this$verifyAndTrimQuotes), lineNo), lineNo);
            } else {
                throw new ParseException("According to the TOML specification string values (even Enums) should be wrapped (start and end) with quotes (\"\"), but the following value was not: <" + $this$verifyAndTrimQuotes + ">.", lineNo);
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final String checkOtherQuotesAreEscaped(String $this$checkOtherQuotesAreEscaped, int lineNo) {
            CharSequence $this$forEachIndexed$iv = $this$checkOtherQuotesAreEscaped;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
                void ch;
                char item$iv = $this$forEachIndexed$iv.charAt(i);
                int n = index$iv++;
                char c = item$iv;
                int index = n;
                boolean bl = false;
                if (ch != 34 || index != 0 && $this$checkOtherQuotesAreEscaped.charAt(index - 1) == '\\') continue;
                throw new ParseException("Found invalid quote that is not escaped. Please remove the quote or use escaping in <" + $this$checkOtherQuotesAreEscaped + "> at position = [" + index + "].", lineNo);
            }
            return $this$checkOtherQuotesAreEscaped;
        }

        private final String checkCountOfOtherUnescapedQuotes(String $this$checkCountOfOtherUnescapedQuotes, int lineNo) {
            if (StringUtilsKt.getCountOfOccurrencesOfSubstring(StringsKt.replace$default((String)$this$checkCountOfOtherUnescapedQuotes, (String)"\\\"", (String)" ", (boolean)false, (int)4, null), "\"\"\"") != 0) {
                throw new ParseException("Multi-line basic string cannot contain 3 or more quotes (\") in a row. Please remove the quotes or use escaping in <" + $this$checkCountOfOtherUnescapedQuotes + '>', lineNo);
            }
            return $this$checkCountOfOtherUnescapedQuotes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

